/*
 * Decompiled with CFR 0.152.
 */
package com.blamejared.crafttweaker.api.data.base.converter;

import com.blamejared.crafttweaker.api.data.ListData;
import com.blamejared.crafttweaker.api.data.MapData;
import com.blamejared.crafttweaker.api.data.StringData;
import com.blamejared.crafttweaker.api.data.base.IData;
import com.blamejared.crafttweaker.api.data.base.converter.NumberConverter;
import com.google.gson.JsonArray;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.JsonPrimitive;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Map;

public class JSONConverter {
    public static IData convert(JsonElement json) {
        if (json == null) {
            return null;
        }
        if (json.isJsonPrimitive()) {
            JsonPrimitive primitive = json.getAsJsonPrimitive();
            if (primitive.isString() || primitive.isBoolean()) {
                return new StringData(primitive.getAsString());
            }
            return NumberConverter.convertNumber(primitive.getAsNumber());
        }
        if (json.isJsonArray()) {
            JsonArray asJsonArray = json.getAsJsonArray();
            ArrayList<IData> dataList = new ArrayList<IData>(asJsonArray.size());
            for (JsonElement jsonElement : asJsonArray) {
                dataList.add(JSONConverter.convert(jsonElement));
            }
            return new ListData(dataList);
        }
        if (json.isJsonObject()) {
            return JSONConverter.convert(json.getAsJsonObject());
        }
        return null;
    }

    public static MapData convert(JsonObject jsonObject) {
        if (jsonObject == null) {
            return null;
        }
        HashMap<String, IData> dataMap = new HashMap<String, IData>();
        for (Map.Entry e : jsonObject.entrySet()) {
            dataMap.put((String)e.getKey(), JSONConverter.convert((JsonElement)e.getValue()));
        }
        return new MapData(dataMap);
    }
}

